/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.eventmon;

import com.ibm.hwmca.fw.eventmon.EventDefinition;
import com.ibm.hwmca.fw.eventmon.EventMonitorConstants;
import com.ibm.hwmca.fw.eventmon.EventMonitorListener;
import com.ibm.hwmca.fw.eventmon.EventMonitorManager;
import com.ibm.hwmca.fw.eventmon.MonitoredEvent;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class EventMonitor
implements EventMonitorConstants,
Serializable {
    static final long serialVersionUID = 4031827718329962445L;
    private static final String TRACE_MASKT = "XLISTENT";
    private static final String TRACE_MASKF = "XLISTENF";
    private static final String TRACE_MASKD = "XLISTEND";
    private static final String THIS_CLASS = "EventMonitor";
    public static final DateFormat CALENDAR_FORMATTER;
    public static final int REGEX_FLAGS = 0;
    public static final boolean[] EVERYDAY;
    private String _name;
    private String _description;
    private boolean _enabled;
    private Set _objectsToMonitor = new HashSet();
    private Pattern _regexPattern;
    private Calendar _startTime;
    private Calendar _endTime;
    private Calendar _startDate;
    private Calendar _endDate;
    private boolean[] _activeDays;
    private String _emailTargets;
    private Locale _locale;
    private transient ResourceBundle _resources;
    private transient Set _listeners = new HashSet();

    public static void appendMember(StringBuffer buff, String name, Object value) {
        buff.append(name);
        buff.append(":  ");
        if (value == null) {
            buff.append("null");
        } else if (value instanceof Calendar) {
            buff.append(CALENDAR_FORMATTER.format(((Calendar)value).getTime()));
        } else {
            buff.append(value.toString());
        }
        buff.append("\n");
    }

    public static void appendMember(StringBuffer buff, String name, int value) {
        buff.append(name);
        buff.append(":  ");
        buff.append(value);
        buff.append("\n");
    }

    public static void appendMember(StringBuffer buff, String name, boolean value) {
        buff.append(name);
        buff.append(":  ");
        buff.append(value);
        buff.append("\n");
    }

    public static void appendMember(StringBuffer buff, String name, double value) {
        buff.append(name);
        buff.append(":  ");
        buff.append(value);
        buff.append("\n");
    }

    public static void normalizeTime(Calendar time) {
        if (time != null) {
            time.set(time.getMinimum(1), time.getMinimum(2), time.getMinimum(5));
        }
    }

    public EventMonitor(String name, String description, boolean enabled, Set objectsToMonitor, Pattern pattern, Calendar startTime, Calendar endTime, Calendar startCalendar, Calendar endCalendar, boolean[] activeDays, String emailTargets, Locale locale) {
        this.setName(name);
        this.setDescription(description);
        this.setObjectsToMonitor(objectsToMonitor);
        this.setPattern(pattern);
        this.setStartTime(startTime);
        this.setEndTime(endTime);
        this.setStartDate(startCalendar);
        this.setEndDate(endCalendar);
        this.setActiveDays(activeDays);
        this.setEmailTargets(emailTargets);
        this.setLocale(locale);
        this.setEnabled(enabled);
        this._resources = ResourceBundle.getBundle("com/ibm/hwmca/base/res/text", locale);
    }

    public abstract void startListening() throws Exception;

    public abstract void stopListening() throws Exception;

    public abstract EventDefinition getEventDefinition() throws Exception;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._listeners = new HashSet();
        this._resources = ResourceBundle.getBundle("com/ibm/hwmca/base/res/text", this.getLocale());
    }

    public String getName() {
        return this._name;
    }

    protected void setName(String name) {
        this._name = name;
    }

    public Set getObjectsToMonitor() {
        return this._objectsToMonitor;
    }

    public void setObjectsToMonitor(Set objectsToMonitor) {
        boolean enabled = this.isEnabled();
        if (enabled) {
            this.setEnabled(false);
        }
        this._objectsToMonitor = objectsToMonitor == null ? new HashSet() : objectsToMonitor;
        this.setEnabled(enabled);
    }

    public String getItemNameInUI() {
        String name = "";
        try {
            name = this.getEventDefinition().getItemNameInUI();
        }
        catch (Exception e) {
            EventMonitorManager.logException((short)4, e);
        }
        return name;
    }

    public String getDefaultName() {
        String name = "";
        try {
            name = this.getEventDefinition().getEventName() + " " + this._resources.getString("task.eventmon.name");
        }
        catch (Exception e) {
            EventMonitorManager.logException((short)4, e);
        }
        return name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description == null ? "" : description;
    }

    public String getDefaultDescription() {
        return this._resources.getString("eventmon.email.addresses.colon") + this._emailTargets;
    }

    public String getEmailTargets() {
        return this._emailTargets;
    }

    public void setEmailTargets(String emailTargets) {
        this._emailTargets = emailTargets == null ? "" : emailTargets;
    }

    public Pattern getPattern() {
        return this._regexPattern;
    }

    public void setPattern(Pattern pattern) {
        this._regexPattern = pattern;
    }

    public Calendar getStartTime() {
        return this._startTime;
    }

    public void setStartTime(Calendar startTime) {
        this._startTime = startTime;
        EventMonitor.normalizeTime(this._startTime);
    }

    public Calendar getEndTime() {
        return this._endTime;
    }

    public void setEndTime(Calendar endTime) {
        this._endTime = endTime;
        EventMonitor.normalizeTime(this._endTime);
    }

    public Calendar getStartDate() {
        return this._startDate;
    }

    public void setStartDate(Calendar startDate) {
        this._startDate = startDate;
    }

    public Calendar getEndDate() {
        return this._endDate;
    }

    public void setEndDate(Calendar endDate) {
        this._endDate = endDate;
    }

    public boolean[] getActiveDays() {
        return this._activeDays;
    }

    public void setActiveDays(boolean[] activeDays) {
        this._activeDays = activeDays == null ? EVERYDAY : activeDays;
    }

    public boolean isLimitedToDates() {
        return this.getStartDate() != null || this.getEndDate() != null;
    }

    public boolean isLimitedToTimes() {
        return this.getStartTime() != null || this.getEndTime() != null;
    }

    public boolean isLimitedToDays() {
        return !this._activeDays[0] || !this._activeDays[1] || !this._activeDays[2] || !this._activeDays[3] || !this._activeDays[4] || !this._activeDays[5] || !this._activeDays[6];
    }

    public synchronized void setEnabled(boolean enabled) {
        Trace.trace(TRACE_MASKF, "--> EventMonitor.setEnabled:  " + enabled);
        if (enabled != this.isEnabled()) {
            this._enabled = enabled;
            if (enabled) {
                Trace.trace(TRACE_MASKD, "EventMonitor.setEnabled:  starting to listen to target objects");
                try {
                    this.startListening();
                }
                catch (Exception e) {
                    this._enabled = !enabled;
                    EventMonitorManager.logException((short)14, e);
                }
            } else {
                Trace.trace(TRACE_MASKD, "EventMonitor.setEnabled:  stopping listening to target objects");
                try {
                    this.stopListening();
                }
                catch (Exception e) {
                    this._enabled = !enabled;
                    EventMonitorManager.logException((short)15, e);
                }
            }
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale == null ? Locale.ENGLISH : locale;
    }

    public void writeToEvent(MonitoredEvent event, String text) {
        if (event.isLogging()) {
            event.log(text);
            event.log("\n");
        }
    }

    private boolean testEventText(MonitoredEvent event) {
        boolean result;
        if (this._regexPattern == null) {
            this.writeToEvent(event, this._resources.getString("eventmon.no.regex"));
            result = true;
        } else {
            String text = event.getText();
            if (this._regexPattern.matcher(text).matches()) {
                result = true;
            } else {
                this.writeToEvent(event, "          " + this._resources.getString("eventmon.regex.not.ok"));
                result = false;
            }
        }
        return result;
    }

    private boolean testEventTime(MonitoredEvent event) {
        return this.testEventStartEndTimes(event) && this.testEventStartEndDates(event) && this.testEventDaysOfWeek(event);
    }

    private boolean timeBetween(Calendar start, Calendar end, Calendar when) {
        Trace.trace(TRACE_MASKF, "--> EventMonitor.timeBetween:  ");
        if (when == null) {
            throw new IllegalArgumentException("Test time may not be null.");
        }
        boolean result = false;
        Calendar testTime = (Calendar)when.clone();
        EventMonitor.normalizeTime(testTime);
        DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, this._locale);
        Trace.trace(TRACE_MASKF, "EventMonitor.timeBetween:  start time is " + (start == null ? "null" : formatter.format(start.getTime())));
        Trace.trace(TRACE_MASKF, "EventMonitor.timeBetween:  end time is " + (end == null ? "null" : formatter.format(end.getTime())));
        Trace.trace(TRACE_MASKF, "EventMonitor.timeBetween:  test time is " + formatter.format(testTime.getTime()));
        if (start != null && end != null && start.get(9) == 1 && end.get(9) == 0) {
            Trace.trace(TRACE_MASKF, "EventMonitor.timeBetween:  got the overnight case");
            result = !this.dateBetween(end, start, testTime) || testTime.equals(start) || testTime.equals(end);
        } else {
            Trace.trace(TRACE_MASKF, "EventMonitor.timeBetween:  got the normal case");
            result = this.dateBetween(start, end, testTime);
        }
        Trace.trace(TRACE_MASKF, "<-- EventMonitor.timeBetween:  returning " + result);
        return result;
    }

    private boolean dateBetween(Calendar start, Calendar end, Calendar when) {
        if (when == null) {
            throw new IllegalArgumentException();
        }
        boolean afterStart = start == null || when.after(start) || when.equals(start);
        boolean beforeEnd = end == null || when.before(end) || when.equals(end);
        return afterStart && beforeEnd;
    }

    private boolean testEventStartEndTimes(MonitoredEvent event) {
        Calendar eventWhen = event.getWhen();
        boolean result = this.timeBetween(this._startTime, this._endTime, eventWhen);
        if (!result) {
            this.writeToEvent(event, "          " + this._resources.getString("eventmon.time.not.ok"));
        }
        return result;
    }

    private boolean testEventStartEndDates(MonitoredEvent event) {
        Calendar eventWhen = event.getWhen();
        boolean result = this.dateBetween(this._startDate, this._endDate, eventWhen);
        if (!result) {
            this.writeToEvent(event, "          " + this._resources.getString("eventmon.date.not.ok"));
        }
        return result;
    }

    private boolean testEventDaysOfWeek(MonitoredEvent event) {
        boolean result;
        Calendar eventWhen = event.getWhen();
        if (this._activeDays == null) {
            result = true;
        } else if (this._activeDays[eventWhen.get(7) - 1]) {
            result = true;
        } else {
            this.writeToEvent(event, "          " + this._resources.getString("eventmon.days.not.ok"));
            result = false;
        }
        return result;
    }

    public void handleEvent(MonitoredEvent event) {
        Trace.trace(TRACE_MASKF, "--> EventMonitor.handleEvent:  event is " + event.dump());
        Trace.trace(TRACE_MASKD, "EventMonitor.handleEvent:  monitor is " + this.dump());
        if (this.isEnabled()) {
            if (this.testEventText(event)) {
                Trace.trace(TRACE_MASKD, "EventMonitor.handleEvent:  event text passed monitor's tests");
                if (this.testEventTime(event)) {
                    Trace.trace(TRACE_MASKD, "EventMonitor.handleEvent:  event time passed monitor's tests");
                    this.writeToEvent(event, "          " + this._resources.getString("eventmon.all.passed"));
                    Set listeners = (Set)((HashSet)this._listeners).clone();
                    Trace.trace(TRACE_MASKF, "EventMonitor.handleEvent:  monitor listener count is " + listeners.size());
                    int count = 0;
                    Iterator i = listeners.iterator();
                    while (i.hasNext()) {
                        try {
                            ((EventMonitorListener)i.next()).handleEvent(event, this);
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKD, "EventMonitor.handleEvent:  listener threw an exception", e);
                        }
                        Trace.trace(TRACE_MASKF, "EventMonitor.handleEvent:  called handleEvent for monitor listener " + count++);
                    }
                } else {
                    Trace.trace(TRACE_MASKD, "EventMonitor.handleEvent:  event time failed monitor's tests");
                }
            } else {
                Trace.trace(TRACE_MASKD, "EventMonitor.handleEvent:  event text failed monitor's tests");
            }
        } else {
            Trace.trace(TRACE_MASKD, "EventMonitor.handleEvent:  monitor not enabled");
            this.writeToEvent(event, "          " + this._resources.getString("eventmon.not.enabled"));
        }
        Trace.trace(TRACE_MASKF, "<-- EventMonitor.handleEvent:  ");
    }

    public String timeString(Calendar time) {
        if (time == null) {
            return this._resources.getString("eventmon.unspecified");
        }
        return DateFormat.getTimeInstance(2, this._locale).format(time.getTime());
    }

    public String dateString(Calendar date) {
        if (date == null) {
            return this._resources.getString("eventmon.unspecified");
        }
        return DateFormat.getDateInstance(2, this._locale).format(date.getTime());
    }

    public String activeDaysString() {
        String[] dayStrings = new DateFormatSymbols(this._locale).getShortWeekdays();
        StringBuffer buff = new StringBuffer();
        buff.append("[  ");
        for (int i = 0; i < this._activeDays.length; ++i) {
            if (!this._activeDays[i]) continue;
            buff.append(dayStrings[i + 1]);
            buff.append(", ");
        }
        buff.replace(buff.length() - 2, buff.length(), " ]");
        return buff.toString();
    }

    public String stateString() {
        return this.stateString("");
    }

    public String stateString(String indent) {
        StringBuffer buff = new StringBuffer();
        this.stateString("eventmon.name.colon", this._name, buff, indent);
        this.stateString("eventmon.description.colon", this._description, buff, indent);
        this.stateString("eventmon.enabled.colon", this._enabled ? "true" : "false", buff, indent);
        this.stateString("eventmon.regex.colon", this._regexPattern.pattern(), buff, indent);
        this.stateString("eventmon.start.time.colon", this.timeString(this._startTime), buff, indent);
        this.stateString("eventmon.end.time.colon", this.timeString(this._endTime), buff, indent);
        this.stateString("eventmon.start.date.colon", this.dateString(this._startDate), buff, indent);
        this.stateString("eventmon.end.date.colon", this.dateString(this._endDate), buff, indent);
        this.stateString("eventmon.active.days.colon", this.activeDaysString(), buff, indent);
        this.stateString("eventmon.email.addresses.colon", this._emailTargets, buff, indent);
        this.stateString("eventmon.locale.colon", this._locale.toString(), buff, indent);
        return buff.toString();
    }

    public String dump() {
        return this.stateString("");
    }

    public void stateString(String key, String value, StringBuffer buff, String indent) {
        buff.append(indent);
        buff.append(this._resources.getString(key));
        buff.append("  '");
        buff.append(value);
        buff.append("'\n");
    }

    public String toString() {
        return this._resources.getString("task.eventmon.name") + "(\n" + this.stateString() + ")\n";
    }

    public void addListener(EventMonitorListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(EventMonitorListener listener) {
        this._listeners.remove(listener);
    }

    static {
        UserContext userContext = UserContext.getCurrentUserContext();
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, userContext.getLocale());
        df.setTimeZone(userContext.getTimeZone());
        CALENDAR_FORMATTER = df;
        EVERYDAY = new boolean[]{true, true, true, true, true, true, true};
    }
}

